setwd("F:\\Wokspace\\C19\\SDL\\Step5\\Pandemiav2.9c-ALL\\data\\traces")
require(XML)
data <-xmlParse("Pandemia (2021-05-04 1314h).trace.xml")
xTime <-xpathSApply(data, "//Events/EYE_Report/@xTime")
agent <-xpathSApply(data, "//Events/EYE_Report/@agent")
varname <-xpathSApply(data, "//Events/EYE_Report/@varname")
vartype <-xpathSApply(data, "//Events/EYE_Report/@vartype")
varvalue <-xpathSApply(data, "//Events/EYE_Report/@varvalue")
label <-xpathSApply(data, "//Events/EYE_Report/@label")
cell<-xpathSApply(data, "//Events/EYE_Report/@cell")

if (length(cell)>0) {
  report_values<-data.frame(xTime, agent, varname, vartype, varvalue, label, cell)
} else report_values<-data.frame(xTime, agent, varname, vartype, varvalue, label)

xTime_array <-xpathSApply(data, "//Events/EYE_ReportArray/@xTime")
agent_array <-xpathSApply(data, "//Events/EYE_ReportArray/@agent")
varname_array <-xpathSApply(data, "//Events/EYE_ReportArray/@varname")
vartype_array <-xpathSApply(data, "//Events/EYE_ReportArray/@vartype")
varvalue_array <-xpathSApply(data, "//Events/EYE_ReportArray/@varvalue")
label_array <-xpathSApply(data, "//Events/EYE_ReportArray/@label")
varname_label <-xpathSApply(data, "//Events/EYE_ReportArray/@varname_label")
vartype_label <-xpathSApply(data, "//Events/EYE_ReportArray/@vartype_label")
varvalue_label <-xpathSApply(data, "//Events/EYE_ReportArray/@varvalue_label")
report_array_values<-data.frame(xTime_array, agent_array, varname_label, vartype_label, varvalue_label, varname_array, vartype_array, varvalue_array, label_array)

list.of.packages <- c("'plotly'", "htmlwidgets")
new.packages <- list.of.packages[!(list.of.packages %in% installed.packages()[,"Package"])]
if(length(new.packages)) install.packages(new.packages, repos = "http://cran.us.r-project.org")

library('plotly')
library('htmlwidgets')

all_reports<-unique(report_values$varname[report_values$vartype!="char*"])
experiments<-unique(report_values$label[report_values$vartype!="char*"])

if (length(cell)>0) {
  
 for (report in all_reports) {
   
    path<-getwd()
    initializeCellsPath<-paste(path,"/../Initialize.img",sep="")
    etiquetes<-read.table(initializeCellsPath)
    
    values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
    time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
    report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
    
    dataframe <-data.frame(time, report_cell, values)
    write.csv2(x = dataframe[order(dataframe$report_cell),], file = paste(report,".csv",sep=""))
    
    cell_position=0
    report_by_cell<-dataframe[dataframe$report_cell==cell_position,]
    cellName<-etiquetes$V1[cell_position+1]
    
    report_cell_name<-paste(cellName,paste(report,paste(paste("Cell",cell_position))))
    
    grafica1 <- plot_ly(report_by_cell, x = report_by_cell$time, y = report_by_cell$values, type = 'scatter', mode = 'lines', name=report_cell_name)

    n_length<-as.numeric(as.character(unique(cell)[-1]))
    for (i in n_length) {
      cellName<-etiquetes$V1[i+1]
      report_cell_name<-paste(cellName,paste(report,paste(paste("Cell",i))))
      grafica1 <- add_trace(grafica1, x = dataframe[dataframe$report_cell==i,]$time,y = dataframe[dataframe$report_cell==i,]$values, name = report_cell_name, line = list(color = 'rgb(22, 96, 167)', width = 2)) 
    }
       
    grafica1 %>% layout(title = report_cell_name,
         xaxis = list(title = "Time"),
         yaxis = list (title = report))
     grafica <- paste(report,"_plotly.html",sep="")
    
    htmlwidgets::saveWidget(as_widget(grafica1), grafica,selfcontained = FALSE)
  }
  
} else {
  
  if (length(experiments)>1) {
    for (report in all_reports) {
      
      values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
      time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
      report_stage <-report_values$label[report_values$varname == report]
      
      dataframe <-data.frame(time, report_stage, values)
      
      stage=experiments[1]
      report_by_stage<-dataframe[dataframe$report_stage==stage,]
      
      grafica1 <- plot_ly(report_by_stage, x = report_by_stage$time, y = report_by_stage$values, type = 'scatter', mode = 'lines', name=stage)
      
      n_length<-length(experiments)-1
      for (i in (1:n_length)) {
        grafica1 <- add_trace(grafica1, x = dataframe[dataframe$report_stage==experiments[i+1],]$time,y = dataframe[dataframe$report_stage==experiments[i+1],]$values, name = experiments[i+1], line = list(color = 'rgb(22, 96, 167)', width = 2)) 
      }
      
      grafica1 %>% layout(title = report,
                          xaxis = list(title = "Time"),
                          yaxis = list (title = report))
      grafica <- paste(report,"_plotly.html",sep="")
      
      htmlwidgets::saveWidget(as_widget(grafica1), grafica,selfcontained = FALSE)
    }
  } else {
  
    for (report in all_reports) {
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      dataframe<-data.frame(time,values)
      
      write.csv2(x = dataframe, file = paste(report,".csv",sep=""))
      
      grafica1 <- plot_ly(dataframe, x = ~dataframe$time, y = ~dataframe$values, type = 'scatter', mode = 'lines', name=paste(report))
          
      grafica1 %>% layout(title = report,
           xaxis = list(title = "Time"),
           yaxis = list (title = report))
           
      grafica <- paste(report,"_plotly.html",sep="")
      htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)
    }
  }
  
}



# installem els paquets si no estan instal·lats
list.of.packages <- c("runner", "dplyr","plotly", "htmlwidgets", "XML")
new.packages <- list.of.packages[!(list.of.packages %in% installed.packages()[,"Package"])]
if(length(new.packages)) install.packages(new.packages)

library(runner)
library(dplyr)

report<-"newInfectiveDetected"
values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
# Calculo del dt
dt=time[time>=2 & time<3]
values<-sum_run(x=values,k=length(dt))

dataframe<-data.frame(time,values)
write.csv2(x = dataframe, file = paste("newInfectiveDetectedDiary",".csv",sep=""))

#write.csv2(x = dataframe, file = paste(report,".csv",sep=""))

# a<-read.table("..\\new_cases.csv")
casosDiaris<-read.csv("..\\casosDiaris.csv")
grafica1 <- plot_ly(type="bar", 
                    x=c(1:length(casosDiaris$nous_casos_confirmats)+30),
                    y = casosDiaris$nous_casos_confirmats,
                    name = 'observations',
                    text = paste("new cases"))

grafica1 <- add_trace(grafica1, x = ~dataframe$time, y = ~dataframe$values, type = 'scatter', mode = 'lines', name=paste(report))
# grafica1 <- add_trace(grafica1, x = c(1:185),y = as.numeric(as.character(a$V1)), mode = 'lines', type = 'scatter', name = "python", line = list(color = 'rgb(22, 196, 67)',width = 2)) 

grafica1 %>% layout(title = report,
                    xaxis = list(title = "Time"),
                    yaxis = list (title = report))

grafica <- paste(report,"2_plotly.html",sep="")
htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

############# denominador ##########################

susc<-as.numeric(as.character(report_values$varvalue[report_values$varname=="susceptible"]))[1]
grafica1 <- plot_ly(type="bar", 
                    x=c(1:length(casosDiaris$nous_casos_confirmats)+30),
                    y = casosDiaris$nous_casos_confirmats,
                    name = 'observations',
                    text = paste("new cases"))

grafica1 <- add_trace(grafica1, x = ~dataframe$time, y = ~dataframe$values/susc, type = 'scatter', mode = 'lines', name=paste(report))
# grafica1 <- add_trace(grafica1, x = c(1:185),y = as.numeric(as.character(a$V1)), mode = 'lines', type = 'scatter', name = "python", line = list(color = 'rgb(22, 196, 67)',width = 2)) 

grafica1 %>% layout(title = report,
                    xaxis = list(title = "Time"),
                    yaxis = list (title = report))

grafica <- paste(report,"_perPoblacio_plotly.html",sep="")
htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)



# report<-"newInfective"
# values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
# time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
# # Calculo del dt
# dt=time[time>=2 & time<3]
# values<-sum_run(x=values,k=length(dt))
# values<-sum_run(x=values,k=7)
# 
# dataframe<-data.frame(time,values)
# 
# #write.csv2(x = dataframe, file = paste(report,".csv",sep=""))
# 
# a<-read.table("..\\new_cases.csv")
# casosDiaris<-read.csv("..\\casosDiaris.csv")
# grafica1 <- plot_ly(type="bar", 
#                     x=c(1:length(casosDiaris$nous_casos_confirmats)+30),
#                     y = casosDiaris$nous_casos_confirmats,
#                     name = 'observations',
#                     text = paste("new cases"))
# 
# grafica1 <- add_trace(grafica1, x = ~dataframe$time, y = ~dataframe$values, type = 'scatter', mode = 'lines', name=paste(report))
# grafica1 <- add_trace(grafica1, x = c(1:185),y = as.numeric(as.character(a$V1)), mode = 'lines', type = 'scatter', name = "python", line = list(color = 'rgb(22, 196, 67)',width = 2)) 
# 
# grafica1 %>% layout(title = report,
#                     xaxis = list(title = "Time"),
#                     yaxis = list (title = report))
# 
# grafica <- paste(report,"_sum7_plotly.html",sep="")
# htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

######################## Detectats Vs Reals #######################################

report<-"newInfectiveDetected"
values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
# Calculo del dt
dt=time[time>=2 & time<3]
values<-sum_run(x=values,k=length(dt))

dataframe<-data.frame(time,values)

reportInfective<-"newInfective"
valuesInfective<-as.numeric(as.character(report_values$varvalue[report_values$varname==reportInfective]))
timeInfective<-as.numeric(as.character(report_values$xTime[report_values$varname==reportInfective]))
# Calculo del dt
dt=timeInfective[timeInfective>=2 & timeInfective<3]
valuesInfective<-sum_run(x=valuesInfective,k=length(dt))

dataframeInfective<-data.frame(timeInfective,valuesInfective)


#write.csv2(x = dataframe, file = paste(report,".csv",sep=""))

# a<-read.table("..\\new_cases.csv")
casosDiaris<-read.csv("..\\casosDiaris.csv")
grafica1 <- plot_ly(type="bar", 
                    x=c(1:length(casosDiaris$nous_casos_confirmats)+30),
                    y = casosDiaris$nous_casos_confirmats,
                    name = 'observations',
                    text = paste("new cases"))

grafica1 <- add_trace(grafica1, x = ~dataframe$time, y = ~dataframe$values, type = 'scatter', mode = 'lines', name=paste(report))

grafica1 <- add_trace(grafica1, x = ~dataframeInfective$timeInfective, y = ~dataframeInfective$valuesInfective, type = 'scatter', mode = 'lines', name=paste(reportInfective))

grafica1 %>% layout(title = report,
                    xaxis = list(title = "Time"),
                    yaxis = list (title = report))

#grafica <- paste(report,"comparative_plotly.html",sep="")
htmlwidgets::saveWidget(as.widget(grafica1), "comparative_plotly.html",selfcontained = FALSE)
